// button.js

qqbrowser.js.widgets.button = qqbrowser.js.base.Class(qqbrowser.js.widgets.widget, {
	className: "qqbrowser.js.widgets.button",
	_bindElement: null,
	
	initialize: function(id) {
		var _this = this;
		
		this._element = document.createElement("div");
		this.setClass("qqbrowser-widgets-button");
		
		this._element.onmouseover = function(event) {
			_this.addClass("hover");
			if (null !== _this._bindElement) {
				_this._bindElement.addClass("hover");
			}
		};
		
		this._element.onmouseout = function(event) {
			_this.removeClass("hover");
			_this.removeClass("pressed");
			
			if (null !== _this._bindElement) {
				_this._bindElement.removeClass("hover");
				_this._bindElement.removeClass("pressed");
			}
		};
		
		this._element.onmousedown = function(event) {
			_this.removeClass("hover");
			_this.addClass("pressed");
			if (null !== _this._bindElement) {
				_this._bindElement.removeClass("hover");
				_this._bindElement.addClass("pressed");
			}
//			if (_this._mousedownListener) {
//				_this._mousedownListener.apply(this, [event]);
//			}
		};
		
		this._element.onmouseup = function(event) {
			_this.removeClass("pressed");
			if (null !== _this._bindElement) {
				_this._bindElement.removeClass("pressed");
			}
		};
		
		this._element.onclick = function() {
			// alert("buttonĬϵΪ\nid=" + _this.id);
		};
		
		this._element.ondblclick = function(event) {
			event.stopPropagation();
			return false;
		};
		
		this._element.oncontextmenu = function() {
			event.stopPropagation();
			return false;
		};
		
		qqbrowser.js.widgets.widget.prototype.initialize.apply(this, [id]);
	},
	
	bind: function(newElement) {
		this._bindElement = newElement;
	}
	
});